#import the required packages including OpenCV
import cv2
from codedeepai import utilsVideo

vid = "./vid/cctv.mp4"

capture = cv2.VideoCapture(vid)
#initialise the basicsVideo object so we can view stats and draw progress bar
uv = utilsVideo(capture)
(fps,frame_count,durationSec) = uv.getStats()
print ("Total time: {}sec FrameRate: {} FrameCount: {}".format(durationSec, fps, frame_count))

while(True):
	# Capture frame-by-frame
	ret, currentframe = capture.read()
	if currentframe is not None:
		
		#display progress bar after saving video so that it does not ge saved with
		#current frame
		currentframe = uv.displayProgressBar(currentframe)
		#display video stream
		cv2.imshow('frame',currentframe)
	else:
		break
	if cv2.waitKey(1) & 0xFF == ord('q'):
		break
	
cv2.destroyAllWindows()


